/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.view;

import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.GeneralPath;

public class SineWaveGraphic
extends PhetShapeGraphic {
    private Dimension _viewportSize;
    private double _maxCycles;
    private double _amplitude;
    private double _frequency;
    private double _startAngle;
    private double _endAngle;
    private GeneralPath _positivePath;
    private GeneralPath _negativePath;

    public SineWaveGraphic(Component component, Dimension dimension) {
        super(component);
        assert (dimension != null);
        this._viewportSize = dimension;
        this._maxCycles = 5.0;
        this._positivePath = new GeneralPath();
        this._negativePath = new GeneralPath();
        this.setBorderColor(Color.GREEN);
        this.setStroke(new BasicStroke(1.0f));
        this.update();
    }

    public void setMaxCycles(double d) {
        assert (d > 0.0);
        this._maxCycles = d;
    }

    public void setAmplitude(double d) {
        assert (this._amplitude >= -1.0 && this._amplitude <= 1.0);
        this._amplitude = d;
    }

    public void setFrequency(double d) {
        assert (d >= 0.0 && d <= 1.0);
        this._frequency = d;
    }

    public double getStartAngle() {
        return this._startAngle;
    }

    public double getEndAngle() {
        return this._endAngle;
    }

    public void update() {
        if (this.isVisible()) {
            double d = this._frequency * this._maxCycles;
            double d2 = Math.PI * 2 * d / (double)this._viewportSize.width;
            this._positivePath.reset();
            this._positivePath.moveTo(0.0f, 0.0f);
            this._negativePath.reset();
            this._negativePath.moveTo(0.0f, 0.0f);
            double d3 = 0.0;
            for (double d4 = 1.0; d4 <= (double)this._viewportSize.width / 2.0; d4 += 1.0) {
                d3 = Math.PI + d4 * d2;
                double d5 = this._amplitude * Math.sin(d3) * (double)this._viewportSize.height / 2.0;
                this._positivePath.lineTo((float)d4, (float)(-d5));
                this._negativePath.lineTo((float)(-d4), (float)d5);
            }
            this._positivePath.append(this._negativePath, false);
            this.setShape(this._positivePath);
            this._startAngle = (Math.PI * 2 - d3 % (Math.PI * 2)) % (Math.PI * 2);
            this._endAngle = this._startAngle + 2.0 * (d3 - Math.PI);
            this.repaint();
        }
    }
}

