/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.view;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.util.ArrayList;

class LightRaysGraphic
extends PhetGraphic {
    private static final double RAYS_START_ANGLE = Math.toRadians(135.0);
    private static final double RAYS_ARC_ANGLE = Math.toRadians(270.0);
    private static final Color RAY_COLOR = Color.YELLOW;
    private static final BasicStroke RAY_STROKE_BIG = new BasicStroke(3.0f, 1, 1);
    private static final BasicStroke RAY_STROKE_MEDIUM = new BasicStroke(2.0f, 1, 1);
    private static final BasicStroke RAY_STROKE_SMALL = new BasicStroke(1.0f, 1, 1);
    private double _bulbRadius;
    private ArrayList<Line2D> _cacheLines;
    private ArrayList<Line2D> _drawLines;
    private Rectangle _bounds;
    private RenderingHints _hints;
    private BasicStroke _stroke;
    private Vector2D _someVector1;
    private Vector2D _someVector2;

    public LightRaysGraphic(Component component, double d) {
        super(component);
        this._bulbRadius = d;
        this._cacheLines = new ArrayList();
        for (int i = 0; i < 60; ++i) {
            this._cacheLines.add(new Line2D.Double());
        }
        this._drawLines = new ArrayList();
        this._bounds = new Rectangle();
        this._hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this._stroke = RAY_STROKE_SMALL;
        this._someVector1 = new Vector2D();
        this._someVector2 = new Vector2D();
    }

    public void setIntensity(double d) {
        int n;
        this._drawLines.clear();
        if (d == 0.0) {
            this._bounds.setBounds(1, 1, 1, 1);
            return;
        }
        int n2 = 8 + (int)(d * 52.0);
        double d2 = 0.0 + d * 350.0;
        this._stroke = RAY_STROKE_SMALL;
        if (d2 > 210.0) {
            this._stroke = RAY_STROKE_BIG;
        } else if (d2 > 105.0) {
            this._stroke = RAY_STROKE_MEDIUM;
        }
        double d3 = RAYS_START_ANGLE;
        double d4 = RAYS_ARC_ANGLE / (double)(n2 - 1);
        for (n = 0; n < n2; ++n) {
            this._someVector1.setMagnitudeAndAngle(this._bulbRadius, d3);
            double d5 = this._someVector1.getX();
            double d6 = this._someVector1.getY();
            this._someVector2.setMagnitudeAndAngle(d2 + this._bulbRadius, d3);
            double d7 = this._someVector2.getX();
            double d8 = this._someVector2.getY();
            Line2D line2D = null;
            if (n < this._cacheLines.size()) {
                line2D = this._cacheLines.get(n);
            } else {
                line2D = new Line2D.Double();
                this._cacheLines.add(line2D);
            }
            line2D.setLine(d5, d6, d7, d8);
            this._drawLines.add(line2D);
            d3 += d4;
        }
        n = (int)(d2 + this._bulbRadius + (double)this._stroke.getLineWidth());
        this._bounds.setBounds(-n, -n, 2 * n, 2 * n);
        this.setBoundsDirty();
    }

    public void paint(Graphics2D graphics2D) {
        int n = this._drawLines.size();
        if (this.isVisible() && n > 0) {
            this.saveGraphicsState(graphics2D);
            graphics2D.setRenderingHints(this._hints);
            graphics2D.setStroke(this._stroke);
            graphics2D.setPaint(RAY_COLOR);
            graphics2D.transform(this.getNetTransform());
            for (int i = 0; i < n; ++i) {
                Line2D line2D = this._drawLines.get(i);
                graphics2D.drawLine((int)line2D.getX1(), (int)line2D.getY1(), (int)line2D.getX2(), (int)line2D.getY2());
            }
            this.restoreGraphicsState();
        }
    }

    protected Rectangle determineBounds() {
        return this.getNetTransform().createTransformedShape(this._bounds).getBounds();
    }
}

