/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.view;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel2;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.faraday.FaradayResources;
import edu.colorado.phet.faraday.FaradayStrings;
import edu.colorado.phet.faraday.model.FieldMeter;
import edu.colorado.phet.faraday.view.FaradayMouseHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class FieldMeterGraphic
extends CompositePhetGraphic
implements SimpleObserver,
ApparatusPanel2.ChangeListener {
    private static final Point CROSSHAIRS_LOCATION = new Point(71, 27);
    private static final Point TITLE_LOCATION = new Point(0, 84);
    private static final Point FIELD_LOCATION = new Point(35, 112);
    private static final Color TITLE_COLOR = Color.WHITE;
    private static final Color FIELD_COLOR = Color.WHITE;
    private static final Font TITLE_FONT = new PhetFont(15);
    private static final Font FIELD_FONT = new PhetFont(15);
    private FieldMeter _fieldMeterModel;
    private PhetTextGraphic _bText;
    private PhetTextGraphic _bxText;
    private PhetTextGraphic _byText;
    private PhetTextGraphic _angleText;
    private NumberFormat _magnitudeFormatter;
    private NumberFormat _angleFormatter;
    private Vector2D _fieldVector;
    private FaradayMouseHandler _mouseHandler;

    public FieldMeterGraphic(Component component, FieldMeter fieldMeter) {
        super(component);
        assert (component != null);
        assert (fieldMeter != null);
        this._fieldMeterModel = fieldMeter;
        fieldMeter.addObserver(this);
        this._magnitudeFormatter = new DecimalFormat("###0.00");
        this._angleFormatter = new DecimalFormat("###0.00");
        this._fieldVector = new Vector2D();
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage bufferedImage = FaradayResources.getImage("fieldMeter.png");
        PhetImageGraphic phetImageGraphic = new PhetImageGraphic(component, bufferedImage);
        phetImageGraphic.setRegistrationPoint(FieldMeterGraphic.CROSSHAIRS_LOCATION.x, FieldMeterGraphic.CROSSHAIRS_LOCATION.y);
        this.addGraphic(phetImageGraphic);
        PhetTextGraphic phetTextGraphic = new PhetTextGraphic(component, TITLE_FONT, FaradayStrings.TITLE_FIELD_METER, TITLE_COLOR, 0, 0);
        int n = phetTextGraphic.getBounds().width;
        int n2 = phetTextGraphic.getBounds().height;
        phetTextGraphic.setRegistrationPoint(n / 2, n2);
        phetTextGraphic.setLocation(FieldMeterGraphic.TITLE_LOCATION.x, FieldMeterGraphic.TITLE_LOCATION.y);
        this.addGraphic(phetTextGraphic);
        int n3 = FieldMeterGraphic.FIELD_LOCATION.x;
        int n4 = FieldMeterGraphic.FIELD_LOCATION.y;
        this._bText = new PhetTextGraphic(component, FIELD_FONT, "", FIELD_COLOR, n3, n4);
        this.addGraphic(this._bText);
        this._bxText = new PhetTextGraphic(component, FIELD_FONT, "", FIELD_COLOR, n3, n4 += 24);
        this.addGraphic(this._bxText);
        this._byText = new PhetTextGraphic(component, FIELD_FONT, "", FIELD_COLOR, n3, n4 += 24);
        this.addGraphic(this._byText);
        this._angleText = new PhetTextGraphic(component, FIELD_FONT, "", FIELD_COLOR, n3, n4 += 24);
        n4 += 24;
        this.addGraphic(this._angleText);
        this._mouseHandler = new FaradayMouseHandler(this._fieldMeterModel, this);
        super.setCursorHand();
        super.addMouseInputListener(this._mouseHandler);
        this.update();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.update();
    }

    public void update() {
        super.setVisible(this._fieldMeterModel.isEnabled());
        if (this.isVisible()) {
            this.setLocation((int)this._fieldMeterModel.getX(), (int)this._fieldMeterModel.getY());
            this._fieldMeterModel.getStrength(this._fieldVector);
            double d = this._fieldVector.getMagnitude();
            double d2 = this._fieldVector.getX();
            double d3 = -this._fieldVector.getY();
            double d4 = -this._fieldVector.getAngle();
            if (Math.abs(d4) >= Math.PI * 2) {
                int n = d4 < 0.0 ? -1 : 1;
                d4 = (double)n * (d4 % (Math.PI * 2));
            }
            if (d4 < -Math.PI) {
                d4 += Math.PI * 2;
            } else if (d4 > Math.PI) {
                d4 -= Math.PI * 2;
            }
            String string = this._magnitudeFormatter.format(d);
            String string2 = this._magnitudeFormatter.format(d2);
            String string3 = this._magnitudeFormatter.format(d3);
            String string4 = this._angleFormatter.format(Math.toDegrees(d4));
            if (string.equals("-0.00")) {
                string = "0.00";
            }
            if (string.equals("0.00")) {
                string2 = "0.00";
                string3 = "0.00";
                string4 = "0.00";
            } else {
                if (string2.equals("-0.00")) {
                    string2 = "0.00";
                }
                if (string3.equals("-0.00")) {
                    string3 = "0.00";
                }
                if (string4.equals("-0.00")) {
                    string4 = "0.00";
                } else if (string4.equals("-180.00")) {
                    string4 = "180.00";
                }
            }
            this._bText.setText(string);
            this._bxText.setText(string2);
            this._byText.setText(string3);
            this._angleText.setText(string4);
            this._bText.setRegistrationPoint(this._bText.getWidth(), this._bText.getHeight());
            this._bxText.setRegistrationPoint(this._bxText.getWidth(), this._bxText.getHeight());
            this._byText.setRegistrationPoint(this._byText.getWidth(), this._byText.getHeight());
            this._angleText.setRegistrationPoint(this._angleText.getWidth(), this._angleText.getHeight());
        }
    }

    public void canvasSizeChanged(ApparatusPanel2.ChangeEvent changeEvent) {
        this._mouseHandler.setDragBounds(0, 0, changeEvent.getCanvasSize().width, changeEvent.getCanvasSize().height);
    }
}

