/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.faraday.FaradayResources;
import edu.colorado.phet.faraday.FaradayStrings;
import edu.colorado.phet.faraday.control.FaradaySlider;
import edu.colorado.phet.faraday.control.GraphicSlider;
import edu.colorado.phet.faraday.model.Battery;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BatteryGraphic
extends GraphicLayerSet
implements SimpleObserver {
    private static final Font VALUE_FONT = new PhetFont(15);
    private static final Color VALUE_COLOR = Color.BLACK;
    private static final Point VALUE_POSITIVE_LOCATION = new Point(158, 83);
    private static final Point VALUE_NEGATIVE_LOCATION = new Point(55, 83);
    private static final DecimalFormat VOLTAGE_FORMAT = new DecimalFormat("0");
    private Battery _batteryModel;
    private PhetImageGraphic _batteryGraphic;
    private GraphicSlider _amplitudeSlider;
    private PhetTextGraphic _amplitudeValue;

    public BatteryGraphic(Component component, Battery battery) {
        super(component);
        this._batteryModel = battery;
        this._batteryModel.addObserver(this);
        BufferedImage bufferedImage = FaradayResources.getImage("battery.png");
        this._batteryGraphic = new PhetImageGraphic(component, bufferedImage);
        this.addGraphic(this._batteryGraphic, 1.0);
        int n = this._batteryGraphic.getWidth() / 2;
        int n2 = 0;
        this._batteryGraphic.setRegistrationPoint(n, n2);
        this._batteryGraphic.setLocation(n, 0);
        this._amplitudeSlider = new FaradaySlider(component, 100);
        this.addGraphic(this._amplitudeSlider, 2.0);
        this._amplitudeSlider.setMinimum((int)(-this._batteryModel.getMaxVoltage()));
        this._amplitudeSlider.setMaximum((int)this._batteryModel.getMaxVoltage());
        this._amplitudeSlider.setValue((int)(this._batteryModel.getAmplitude() * this._batteryModel.getMaxVoltage()));
        this._amplitudeSlider.addTick(this._amplitudeSlider.getMinimum());
        this._amplitudeSlider.addTick(this._amplitudeSlider.getMaximum());
        this._amplitudeSlider.addTick(0);
        this._amplitudeSlider.centerRegistrationPoint();
        this._amplitudeSlider.setLocation(105, 35);
        this._amplitudeSlider.addChangeListener(new SliderListener());
        this._amplitudeValue = new PhetTextGraphic(component, VALUE_FONT, "", VALUE_COLOR);
        this.addGraphic(this._amplitudeValue, 3.0);
        int n3 = this.getWidth() / 2;
        n = this.getHeight();
        this.setRegistrationPoint(n3, n);
        this.update();
    }

    public void update() {
        this.setVisible(this._batteryModel.isEnabled());
        if (this.isVisible()) {
            int n;
            double d = this._batteryModel.getVoltage();
            this._batteryGraphic.clearTransform();
            if (d < 0.0) {
                this._batteryGraphic.scale(-1.0, 1.0);
            }
            if ((n = (int)(this._batteryModel.getAmplitude() * this._batteryModel.getMaxVoltage())) != this._amplitudeSlider.getValue()) {
                this._amplitudeSlider.setValue(n);
            }
            String string = VOLTAGE_FORMAT.format(Math.abs(d)) + " " + FaradayStrings.UNITS_VOLTS;
            this._amplitudeValue.setText(string);
            if (d < 0.0) {
                this._amplitudeValue.setLocation(VALUE_NEGATIVE_LOCATION);
            } else {
                this._amplitudeValue.setLocation(VALUE_POSITIVE_LOCATION);
            }
            int n2 = this._amplitudeValue.getBounds().width;
            int n3 = this._amplitudeValue.getBounds().height;
            this._amplitudeValue.setRegistrationPoint(n2, n3);
            this.repaint();
        }
    }

    private class SliderListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == BatteryGraphic.this._amplitudeSlider) {
                int n = BatteryGraphic.this._amplitudeSlider.getValue();
                BatteryGraphic.this._batteryModel.setAmplitude((double)n / BatteryGraphic.this._batteryModel.getMaxVoltage());
            }
        }
    }
}

