/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.faraday.model.BarMagnet;
import edu.colorado.phet.faraday.view.AbstractBFieldGraphic;
import edu.colorado.phet.faraday.view.NeedleColorStrategy;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class BFieldInsideGraphic
extends AbstractBFieldGraphic
implements SimpleObserver {
    private BarMagnet _barMagnetModel;
    private Point2D _barMagnetLocation;
    private AffineTransform _transform;
    private Point2D _point2D;
    private Rectangle _rect;

    public BFieldInsideGraphic(Component component, BarMagnet barMagnet) {
        super(component, barMagnet, 34, 20);
        this.setNeedleColorStrategy(new NeedleColorStrategy.AlphaColorStrategy());
        this._barMagnetModel = barMagnet;
        this._barMagnetModel.addObserver(this);
        this._barMagnetLocation = new Point2D.Double();
        this._transform = new AffineTransform();
        this._point2D = new Point2D.Double();
        this._rect = new Rectangle();
        this.update();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.update();
        }
    }

    protected AbstractBFieldGraphic.GridPoint[] createGridPoints() {
        this._barMagnetModel.getLocation(this._barMagnetLocation);
        ArrayList<AbstractBFieldGraphic.GridPoint> arrayList = new ArrayList<AbstractBFieldGraphic.GridPoint>();
        double d = this.getXSpacing();
        double d2 = this.getYSpacing();
        double d3 = this._barMagnetLocation.getX();
        double d4 = this._barMagnetLocation.getY();
        for (int i = 0; i <= 3; ++i) {
            double d5 = d4 - d2 / 2.0;
            double d6 = d3 + (double)i * d;
            AbstractBFieldGraphic.GridPoint gridPoint = new AbstractBFieldGraphic.GridPoint(d6, d5);
            arrayList.add(gridPoint);
            d6 = d3 - (double)i * d;
            gridPoint = new AbstractBFieldGraphic.GridPoint(d6, d5);
            arrayList.add(gridPoint);
            d5 = d4 + d2 / 2.0;
            d6 = d3 + (double)i * d;
            gridPoint = new AbstractBFieldGraphic.GridPoint(d6, d5);
            arrayList.add(gridPoint);
            d6 = d3 - (double)i * d;
            gridPoint = new AbstractBFieldGraphic.GridPoint(d6, d5);
            arrayList.add(gridPoint);
        }
        double d7 = this._barMagnetModel.getDirection();
        if (d7 != 0.0) {
            for (AbstractBFieldGraphic.GridPoint gridPoint : arrayList) {
                this._point2D.setLocation(gridPoint.getX(), gridPoint.getY());
                this._transform.setToIdentity();
                this._transform.translate(d3, d4);
                this._transform.rotate(d7);
                this._transform.translate(-d3, -d4);
                this._transform.transform(this._point2D, this._point2D);
                gridPoint.setLocation(this._point2D.getX(), this._point2D.getY());
            }
        }
        return arrayList.toArray(new AbstractBFieldGraphic.GridPoint[arrayList.size()]);
    }

    public void update() {
        if (this.isVisible()) {
            double d = this._barMagnetModel.getX();
            double d2 = this._barMagnetModel.getY();
            int n = (int)(d - this._barMagnetModel.getWidth() / 2.0);
            int n2 = (int)(d2 - this._barMagnetModel.getHeight() / 2.0);
            this._rect.setRect(n, n2, (int)this._barMagnetModel.getWidth(), (int)this._barMagnetModel.getHeight());
            Rectangle rectangle = this._rect;
            double d3 = this._barMagnetModel.getDirection();
            if (d3 != 0.0) {
                this._transform.setToIdentity();
                this._transform.translate(d, d2);
                this._transform.rotate(d3);
                this._transform.translate(-d, -d2);
                Shape shape = this._transform.createTransformedShape(this._rect);
                rectangle = shape.getBounds();
            }
            this.setGridBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }
}

