/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.module;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel3;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.faraday.FaradayConstants;
import edu.colorado.phet.faraday.FaradayStrings;
import edu.colorado.phet.faraday.control.FaradayControlPanel;
import edu.colorado.phet.faraday.control.panel.BarMagnetPanel;
import edu.colorado.phet.faraday.control.panel.DeveloperControlsPanel;
import edu.colorado.phet.faraday.model.BarMagnet;
import edu.colorado.phet.faraday.model.Compass;
import edu.colorado.phet.faraday.model.FieldMeter;
import edu.colorado.phet.faraday.module.FaradayModule;
import edu.colorado.phet.faraday.view.BFieldInsideGraphic;
import edu.colorado.phet.faraday.view.BFieldOutsideGraphic;
import edu.colorado.phet.faraday.view.BarMagnetGraphic;
import edu.colorado.phet.faraday.view.CompassGraphic;
import edu.colorado.phet.faraday.view.EarthGraphic;
import edu.colorado.phet.faraday.view.FieldMeterGraphic;
import edu.colorado.phet.faraday.view.WiggleMeGraphic;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public class BarMagnetModule
extends FaradayModule {
    private static final Point BAR_MAGNET_LOCATION = new Point(450, 300);
    private static final Point COMPASS_LOCATION = new Point(150, 300);
    private static final Point FIELD_METER_LOCATION = new Point(150, 400);
    private static final Point WIGGLE_ME_LOCATION = new Point(250, 175);
    private static final Color APPARATUS_BACKGROUND = Color.BLACK;
    private static final Dimension BAR_MAGNET_SIZE = FaradayConstants.BAR_MAGNET_SIZE;
    private BarMagnet _barMagnetModel;
    private Compass _compassModel;
    private FieldMeter _fieldMeterModel;
    private BarMagnetGraphic _barMagnetGraphic;
    private EarthGraphic _earthGraphic;
    private BFieldOutsideGraphic _bFieldOutsideGraphic;
    private BFieldInsideGraphic _bFieldInsideGraphic;
    private BarMagnetPanel _barMagnetPanel;

    public BarMagnetModule(boolean bl) {
        super(FaradayStrings.TITLE_BAR_MAGNET_MODULE);
        BaseModel baseModel = new BaseModel();
        this.setModel(baseModel);
        this._barMagnetModel = new BarMagnet();
        this._barMagnetModel.setSize(BAR_MAGNET_SIZE.getWidth(), BAR_MAGNET_SIZE.getHeight());
        this._barMagnetModel.setMaxStrength(300.0);
        this._barMagnetModel.setMinStrength(0.0);
        this._barMagnetModel.setStrength(225.0);
        this._barMagnetModel.setLocation(BAR_MAGNET_LOCATION);
        this._barMagnetModel.setDirection(0.0);
        this._compassModel = new Compass(this._barMagnetModel, this.getClock());
        this._compassModel.setLocation(COMPASS_LOCATION);
        this._compassModel.setBehavior(2);
        baseModel.addModelElement(this._compassModel);
        this._fieldMeterModel = new FieldMeter(this._barMagnetModel);
        this._fieldMeterModel.setLocation(FIELD_METER_LOCATION);
        this._fieldMeterModel.setEnabled(false);
        ApparatusPanel3 apparatusPanel3 = new ApparatusPanel3(this.getClock(), 783, 630);
        apparatusPanel3.setBackground(APPARATUS_BACKGROUND);
        this.setApparatusPanel(apparatusPanel3);
        this._barMagnetGraphic = new BarMagnetGraphic((Component)apparatusPanel3, this._barMagnetModel);
        apparatusPanel3.addChangeListener(this._barMagnetGraphic);
        apparatusPanel3.addGraphic(this._barMagnetGraphic, 2.0);
        this._earthGraphic = new EarthGraphic((Component)apparatusPanel3, this._barMagnetModel);
        apparatusPanel3.addGraphic(this._earthGraphic, 5.0);
        this._bFieldInsideGraphic = new BFieldInsideGraphic(apparatusPanel3, this._barMagnetModel);
        this._bFieldInsideGraphic.setNeedleSize(FaradayConstants.GRID_NEEDLE_SIZE);
        apparatusPanel3.addGraphic(this._bFieldInsideGraphic, 2.0);
        this._bFieldOutsideGraphic = new BFieldOutsideGraphic(apparatusPanel3, this._barMagnetModel, 40, 40);
        this._bFieldOutsideGraphic.setNeedleSize(FaradayConstants.GRID_NEEDLE_SIZE);
        this._bFieldOutsideGraphic.setGridBackground(APPARATUS_BACKGROUND);
        apparatusPanel3.addChangeListener(this._bFieldOutsideGraphic);
        apparatusPanel3.addGraphic(this._bFieldOutsideGraphic, 1.0);
        super.setBFieldOutsideGraphic(this._bFieldOutsideGraphic);
        CompassGraphic compassGraphic = new CompassGraphic(apparatusPanel3, this._compassModel);
        apparatusPanel3.addChangeListener(compassGraphic);
        apparatusPanel3.addGraphic(compassGraphic, 3.0);
        FieldMeterGraphic fieldMeterGraphic = new FieldMeterGraphic(apparatusPanel3, this._fieldMeterModel);
        fieldMeterGraphic.setLocation(FIELD_METER_LOCATION);
        apparatusPanel3.addChangeListener(fieldMeterGraphic);
        apparatusPanel3.addGraphic(fieldMeterGraphic, 4.0);
        this._barMagnetGraphic.getCollisionDetector().add(compassGraphic);
        compassGraphic.getCollisionDetector().add(this._barMagnetGraphic);
        this.setClockControlPanelEmpty(true);
        Object object = new FaradayControlPanel();
        this.setControlPanel((JComponent)object);
        this._barMagnetPanel = new BarMagnetPanel(this._barMagnetModel, this._compassModel, this._fieldMeterModel, this._bFieldInsideGraphic, this._bFieldOutsideGraphic, this._earthGraphic);
        ((ControlPanel)object).addControlFullWidth(this._barMagnetPanel);
        if (PhetApplication.getInstance().isDeveloperControlsEnabled()) {
            ((FaradayControlPanel)object).addDefaultVerticalSpace();
            DeveloperControlsPanel developerControlsPanel = new DeveloperControlsPanel(null, null, null, null, this._bFieldInsideGraphic, this._bFieldOutsideGraphic);
            ((ControlPanel)object).addControlFullWidth(developerControlsPanel);
        }
        ((ControlPanel)object).addResetAllButton(this);
        this.reset();
        if (bl) {
            object = new ThisWiggleMeGraphic(apparatusPanel3, baseModel, this._barMagnetModel, this._compassModel);
            ((WiggleMeGraphic)object).setLocation(WIGGLE_ME_LOCATION);
            apparatusPanel3.addGraphic((PhetGraphic)object, Double.MAX_VALUE);
        }
    }

    public void reset() {
        this._barMagnetModel.setStrength(225.0);
        this._barMagnetModel.setLocation(BAR_MAGNET_LOCATION);
        this._barMagnetModel.setDirection(0.0);
        this._compassModel.setLocation(COMPASS_LOCATION);
        this._compassModel.setEnabled(true);
        this._bFieldInsideGraphic.setVisible(false);
        this._earthGraphic.setVisible(false);
        this._bFieldOutsideGraphic.setVisible(true);
        this._fieldMeterModel.setLocation(FIELD_METER_LOCATION);
        this._fieldMeterModel.setEnabled(false);
        this._barMagnetPanel.update();
    }

    public void setShowEarthVisible(boolean bl) {
        this._barMagnetPanel.setShowEarthControlVisible(bl);
    }

    private static class ThisWiggleMeGraphic
    extends WiggleMeGraphic
    implements SimpleObserver {
        private BarMagnet _barMagnetModel;
        private Point2D _barMagnetLocation;
        private Compass _compassModel;
        private Point2D _compassLocation;

        public ThisWiggleMeGraphic(Component component, BaseModel baseModel, BarMagnet barMagnet, Compass compass) {
            super(component, baseModel);
            this._barMagnetModel = barMagnet;
            this._barMagnetLocation = barMagnet.getLocation();
            barMagnet.addObserver(this);
            this._compassModel = compass;
            this._compassLocation = compass.getLocation();
            compass.addObserver(this);
            this.setText(FaradayStrings.WIGGLEME_BAR_MAGNET);
            this.addArrow(5, new Vector2D(-40.0, 50.0));
            this.addArrow(7, new Vector2D(40.0, 50.0));
            this.setRange(20, 10);
            this.setEnabled(true);
        }

        public void update() {
            if (!this._barMagnetLocation.equals(this._barMagnetModel.getLocation()) || !this._compassLocation.equals(this._compassModel.getLocation())) {
                this.setEnabled(false);
                this._barMagnetModel.removeObserver(this);
                this._compassModel.removeObserver(this);
            }
        }
    }
}

