/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.model;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.faraday.model.FaradayObservable;
import edu.colorado.phet.faraday.model.PickupCoil;

public class Voltmeter
extends FaradayObservable
implements ModelElement,
SimpleObserver {
    private static final double ZERO_NEEDLE_ANGLE = Math.toRadians(0.0);
    private static final double MAX_NEEDLE_ANGLE = Math.toRadians(90.0);
    private static final double NEEDLE_JIGGLE_ANGLE = Math.toRadians(3.0);
    private static final double NEEDLE_JIGGLE_THRESHOLD = Math.toRadians(0.5);
    private PickupCoil _pickupCoilModel;
    private boolean _jiggleEnabled;
    private double _needleAngle;

    public Voltmeter(PickupCoil pickupCoil) {
        assert (pickupCoil != null);
        this._pickupCoilModel = pickupCoil;
        this._pickupCoilModel.addObserver(this);
        this._jiggleEnabled = false;
        this._needleAngle = ZERO_NEEDLE_ANGLE;
    }

    public void setJiggleEnabled(boolean bl) {
        if (bl != this._jiggleEnabled) {
            this._jiggleEnabled = bl;
        }
    }

    protected void setNeedleAngle(double d) {
        if ((d = MathUtil.clamp(-MAX_NEEDLE_ANGLE, d, MAX_NEEDLE_ANGLE)) != this._needleAngle) {
            this._needleAngle = d;
            this.notifyObservers();
        }
    }

    public double getNeedleAngle() {
        return this._needleAngle;
    }

    private double getDesiredNeedleAngle() {
        double d = this._pickupCoilModel.getCurrentAmplitude();
        if (Math.abs(d) < 0.001) {
            d = 0.0;
        }
        return d * MAX_NEEDLE_ANGLE;
    }

    public void stepInTime(double d) {
        if (this.isEnabled()) {
            double d2 = this.getDesiredNeedleAngle();
            if (!this._jiggleEnabled) {
                this.setNeedleAngle(d2);
            } else if (d2 != ZERO_NEEDLE_ANGLE) {
                this.setNeedleAngle(d2);
            } else {
                double d3 = this.getNeedleAngle();
                if (d3 != 0.0) {
                    if (Math.abs(d3) < NEEDLE_JIGGLE_THRESHOLD) {
                        this.setNeedleAngle(ZERO_NEEDLE_ANGLE);
                    } else {
                        double d4 = -d3 * 0.6;
                        d4 = MathUtil.clamp(-NEEDLE_JIGGLE_ANGLE, d4, NEEDLE_JIGGLE_ANGLE);
                        this.setNeedleAngle(d4);
                    }
                }
            }
        }
    }

    public void update() {
    }
}

