/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.model;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.faraday.model.FaradayObservable;
import edu.colorado.phet.faraday.model.PickupCoil;

public class Lightbulb
extends FaradayObservable
implements SimpleObserver {
    private PickupCoil _pickupCoilModel;
    private double _previousCurrentAmplitude;
    private boolean _offWhenCurrentChangesDirection;

    public Lightbulb(PickupCoil pickupCoil) {
        this._pickupCoilModel = pickupCoil;
        this._pickupCoilModel.addObserver(this);
        this._previousCurrentAmplitude = 0.0;
        this._offWhenCurrentChangesDirection = false;
    }

    public double getIntensity() {
        double d = 0.0;
        double d2 = this._pickupCoilModel.getCurrentAmplitude();
        if (this._offWhenCurrentChangesDirection && (d2 > 0.0 && this._previousCurrentAmplitude <= 0.0 || d2 <= 0.0 && this._previousCurrentAmplitude > 0.0)) {
            d = 0.0;
        } else {
            d = Math.abs(d2);
            if (d < 0.001) {
                d = 0.0;
            }
        }
        this._previousCurrentAmplitude = d2;
        assert (d >= 0.0 && d <= 1.0);
        return d;
    }

    public void setOffWhenCurrentChangesDirection(boolean bl) {
        this._offWhenCurrentChangesDirection = bl;
    }

    public void update() {
        if (this.isEnabled()) {
            this.notifyObservers();
        }
    }
}

