/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.faraday.model.AbstractMagnet;
import edu.colorado.phet.faraday.model.FaradayObservable;
import java.awt.geom.Point2D;

public class Compass
extends FaradayObservable
implements ModelElement,
SimpleObserver {
    private AbstractMagnet _magnetModel;
    private IClock _clock;
    private IBehavior _behavior;
    private Point2D _somePoint;
    private Vector2D _someVector;
    private IBehavior _clockPausedBehavior;

    public Compass(AbstractMagnet abstractMagnet, IClock iClock) {
        assert (abstractMagnet != null);
        this._magnetModel = abstractMagnet;
        this._magnetModel.addObserver(this);
        this._clock = iClock;
        this._behavior = new ImmediateBehavior(this);
        this._clockPausedBehavior = new ImmediateBehavior(this);
        this._somePoint = new Point2D.Double();
        this._someVector = new Vector2D();
        Vector2D vector2D = this._magnetModel.getBField(this.getLocation());
        this.setDirection(vector2D.getAngle());
    }

    public void setBehavior(int n) {
        switch (n) {
            case 0: {
                this._behavior = new ImmediateBehavior(this);
                break;
            }
            case 1: {
                this._behavior = new IncrementalBehavior(this);
                break;
            }
            case 2: {
                this._behavior = new KinematicBehavior(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid behavior requested: " + n);
            }
        }
    }

    public void startMovingNow() {
        this._behavior.startMovingNow();
    }

    public void notifySelf() {
        this.update();
    }

    public void update() {
        if (this._clock.isPaused()) {
            this.getLocation(this._somePoint);
            this._magnetModel.getBField(this._somePoint, this._someVector);
            this._clockPausedBehavior.setDirection(this._someVector, 1.0);
        }
    }

    public void stepInTime(double d) {
        if (this.isEnabled()) {
            this.getLocation(this._somePoint);
            this._magnetModel.getBField(this._somePoint, this._someVector);
            if (this._someVector.getMagnitude() != 0.0) {
                this._behavior.setDirection(this._someVector, d);
            }
        }
    }

    private static abstract class AbstractBehavior
    implements IBehavior {
        private Compass _compassModel;

        public AbstractBehavior(Compass compass) {
            this._compassModel = compass;
        }

        public Compass getCompass() {
            return this._compassModel;
        }

        public void startMovingNow() {
        }
    }

    private static interface IBehavior {
        public void setDirection(Vector2D var1, double var2);

        public void startMovingNow();
    }

    private static class ImmediateBehavior
    extends AbstractBehavior {
        public ImmediateBehavior(Compass compass) {
            super(compass);
        }

        public void setDirection(Vector2D vector2D, double d) {
            this.getCompass().setDirection(vector2D.getAngle());
        }
    }

    private static class IncrementalBehavior
    extends AbstractBehavior {
        private static final double MAX_INCREMENT = Math.toRadians(45.0);

        public IncrementalBehavior(Compass compass) {
            super(compass);
        }

        public void setDirection(Vector2D vector2D, double d) {
            int n;
            double d2;
            double d3 = vector2D.getAngle();
            double d4 = d3 - (d2 = this.getCompass().getDirection());
            if (Math.abs(d4) >= Math.PI * 2) {
                n = d4 < 0.0 ? -1 : 1;
                d4 = (double)n * (d4 % (Math.PI * 2));
            }
            if (d4 > Math.PI) {
                d4 -= Math.PI * 2;
            } else if (d4 < -Math.PI) {
                d4 += Math.PI * 2;
            }
            if (Math.abs(d4) < MAX_INCREMENT) {
                this.getCompass().setDirection(d3);
            } else {
                n = d4 < 0.0 ? -1 : 1;
                d4 = (double)n * MAX_INCREMENT;
                this.getCompass().setDirection(d2 + d4);
            }
        }
    }

    private static class KinematicBehavior
    extends AbstractBehavior {
        private static final double THRESHOLD = Math.toRadians(0.2);
        private double _theta = 0.0;
        private double _omega = 0.0;
        private double _alpha = 0.0;

        public KinematicBehavior(Compass compass) {
            super(compass);
        }

        public void setDirection(Vector2D vector2D, double d) {
            double d2;
            double d3 = vector2D.getMagnitude();
            double d4 = vector2D.getAngle();
            double d5 = d2 = d3 == 0.0 ? 0.0 : d4 - this._theta;
            if (Math.abs(d2) < THRESHOLD) {
                this._theta = d4;
                this._omega = 0.0;
                this._alpha = 0.0;
                this.getCompass().setDirection(this._theta);
            } else {
                double d6 = this._theta;
                double d7 = 0.01 * Math.sin(d2) * d3 - 0.08 * this._omega;
                this._theta = this._theta + this._omega * d + 0.5 * d7 * d * d;
                if (this._theta != d6) {
                    this.getCompass().setDirection(this._theta);
                }
                double d8 = this._omega + d7 * d;
                this._alpha = 0.01 * Math.sin(d2) * d3 - 0.08 * d8;
                this._omega += 0.5 * (this._alpha + d7) * d;
            }
        }

        public void startMovingNow() {
            this._omega = 0.03;
        }
    }
}

