/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.control.panel;

import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.faraday.FaradayResources;
import edu.colorado.phet.faraday.FaradayStrings;
import edu.colorado.phet.faraday.control.panel.FaradayPanel;
import edu.colorado.phet.faraday.model.Lightbulb;
import edu.colorado.phet.faraday.model.PickupCoil;
import edu.colorado.phet.faraday.model.Voltmeter;
import edu.colorado.phet.faraday.view.CoilGraphic;
import edu.colorado.phet.faraday.view.PickupCoilGraphic;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public class PickupCoilPanel
extends FaradayPanel {
    private PickupCoil _pickupCoilModel;
    private CoilGraphic _coilGraphic;
    private Lightbulb _lightbulbModel;
    private Voltmeter _voltmeterModel;
    private JSpinner _loopsSpinner;
    private LinearValueControl _areaControl;
    private JRadioButton _voltmeterRadioButton;
    private JRadioButton _lightbulbRadioButton;
    private JCheckBox _electronsCheckBox;

    public PickupCoilPanel(PickupCoil pickupCoil, PickupCoilGraphic pickupCoilGraphic, Lightbulb lightbulb, Voltmeter voltmeter) {
        assert (pickupCoil != null);
        assert (pickupCoilGraphic != null);
        assert (lightbulb != null);
        assert (voltmeter != null);
        this._pickupCoilModel = pickupCoil;
        this._coilGraphic = pickupCoilGraphic.getCoilGraphic();
        this._lightbulbModel = lightbulb;
        this._voltmeterModel = voltmeter;
        Border border = BorderFactory.createLineBorder(Color.BLACK, 2);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, FaradayStrings.TITLE_PICKUP_COIL_PANEL);
        titledBorder.setTitleFont(this.getTitleFont());
        this.setBorder(titledBorder);
        JPanel jPanel = new JPanel();
        Serializable serializable = new TitledBorder(FaradayStrings.TITLE_INDICATOR);
        jPanel.setBorder((Border)((Object)serializable));
        Serializable serializable2 = new EasyGridBagLayout(jPanel);
        jPanel.setLayout((LayoutManager)((Object)serializable2));
        Serializable serializable3 = new ImageIcon(FaradayResources.getImage("lightbulb_icon.png"));
        Object object = new ImageIcon(FaradayResources.getImage("lightbulb_icon_selected.png"));
        this._lightbulbRadioButton = new JRadioButton((Icon)((Object)serializable3));
        this._lightbulbRadioButton.setSelectedIcon((Icon)object);
        Serializable serializable4 = new ImageIcon(FaradayResources.getImage("voltmeter_icon.png"));
        ImageIcon imageIcon = new ImageIcon(FaradayResources.getImage("voltmeter_icon_selected.png"));
        this._voltmeterRadioButton = new JRadioButton((Icon)((Object)serializable4));
        this._voltmeterRadioButton.setSelectedIcon(imageIcon);
        serializable2.addAnchoredComponent(this._lightbulbRadioButton, 0, 0, 17);
        serializable2.addAnchoredComponent(this._voltmeterRadioButton, 0, 1, 17);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._lightbulbRadioButton);
        buttonGroup.add(this._voltmeterRadioButton);
        serializable = new JPanel();
        serializable2 = new JLabel(FaradayStrings.LABEL_NUMBER_OF_LOOPS);
        serializable3 = new SpinnerNumberModel();
        ((SpinnerNumberModel)serializable3).setMaximum(new Integer(3));
        ((SpinnerNumberModel)serializable3).setMinimum(new Integer(1));
        ((SpinnerNumberModel)serializable3).setValue(new Integer(1));
        this._loopsSpinner = new JSpinner((SpinnerModel)((Object)serializable3));
        object = ((JSpinner.DefaultEditor)this._loopsSpinner.getEditor()).getTextField();
        ((JTextComponent)object).setEditable(false);
        this._loopsSpinner.setPreferredSize(SPINNER_SIZE);
        this._loopsSpinner.setMaximumSize(SPINNER_SIZE);
        this._loopsSpinner.setMinimumSize(SPINNER_SIZE);
        serializable4 = new EasyGridBagLayout((JPanel)serializable);
        ((Container)serializable).setLayout((LayoutManager)((Object)serializable4));
        ((EasyGridBagLayout)serializable4).addAnchoredComponent((Component)serializable2, 0, 0, 17);
        ((EasyGridBagLayout)serializable4).addAnchoredComponent(this._loopsSpinner, 0, 1, 17);
        int n = 100;
        int n2 = 20;
        this._areaControl = new LinearValueControl(n2, n, FaradayStrings.LABEL_LOOP_AREA, "0", "%");
        this._areaControl.setValue(n2);
        this._areaControl.setMinorTickSpacing(10.0);
        this._areaControl.setTextFieldEditable(true);
        this._areaControl.setTextFieldColumns(3);
        this._areaControl.setUpDownArrowDelta(1.0);
        this._areaControl.setBorder(BorderFactory.createEtchedBorder());
        this._electronsCheckBox = new JCheckBox(FaradayStrings.CHECK_BOX_SHOW_ELECTRONS);
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(this);
        this.setLayout(easyGridBagLayout);
        n2 = 0;
        easyGridBagLayout.addFilledComponent(jPanel, n2++, 0, 2);
        easyGridBagLayout.addComponent((Component)serializable, n2++, 0);
        easyGridBagLayout.addFilledComponent(this._areaControl, n2++, 0, 2);
        easyGridBagLayout.addComponent(this._electronsCheckBox, n2++, 0);
        object = new EventListener();
        this._loopsSpinner.addChangeListener((ChangeListener)object);
        this._areaControl.addChangeListener((ChangeListener)object);
        this._lightbulbRadioButton.addActionListener((ActionListener)object);
        this._voltmeterRadioButton.addActionListener((ActionListener)object);
        this._electronsCheckBox.addActionListener((ActionListener)object);
        this.update();
    }

    public void update() {
        this._loopsSpinner.setValue(new Integer(this._pickupCoilModel.getNumberOfLoops()));
        this._areaControl.setValue((int)(100.0 * this._pickupCoilModel.getLoopArea() / 70685.83470577035));
        this._lightbulbRadioButton.setSelected(this._lightbulbModel.isEnabled());
        this._voltmeterRadioButton.setSelected(this._voltmeterModel.isEnabled());
        this._electronsCheckBox.setSelected(this._coilGraphic.isElectronAnimationEnabled());
    }

    private class EventListener
    implements ActionListener,
    ChangeListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == PickupCoilPanel.this._lightbulbRadioButton) {
                PickupCoilPanel.this._lightbulbModel.setEnabled(PickupCoilPanel.this._lightbulbRadioButton.isSelected());
                PickupCoilPanel.this._voltmeterModel.setEnabled(!PickupCoilPanel.this._lightbulbRadioButton.isSelected());
            } else if (actionEvent.getSource() == PickupCoilPanel.this._voltmeterRadioButton) {
                PickupCoilPanel.this._voltmeterModel.setEnabled(PickupCoilPanel.this._voltmeterRadioButton.isSelected());
                PickupCoilPanel.this._lightbulbModel.setEnabled(!PickupCoilPanel.this._voltmeterRadioButton.isSelected());
            } else if (actionEvent.getSource() == PickupCoilPanel.this._electronsCheckBox) {
                PickupCoilPanel.this._coilGraphic.setElectronAnimationEnabled(PickupCoilPanel.this._electronsCheckBox.isSelected());
            } else {
                throw new IllegalArgumentException("unexpected event: " + actionEvent);
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == PickupCoilPanel.this._areaControl) {
                int n = (int)PickupCoilPanel.this._areaControl.getValue();
                double d = (double)n / 100.0 * 70685.83470577035;
                PickupCoilPanel.this._pickupCoilModel.setLoopArea(d);
            } else if (changeEvent.getSource() == PickupCoilPanel.this._loopsSpinner) {
                int n = (Integer)PickupCoilPanel.this._loopsSpinner.getValue();
                PickupCoilPanel.this._pickupCoilModel.setNumberOfLoops(n);
            } else {
                throw new IllegalArgumentException("unexpected event: " + changeEvent);
            }
        }
    }
}

