/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.control.panel;

import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.faraday.FaradayResources;
import edu.colorado.phet.faraday.FaradayStrings;
import edu.colorado.phet.faraday.control.panel.FaradayPanel;
import edu.colorado.phet.faraday.model.ACPowerSupply;
import edu.colorado.phet.faraday.model.Battery;
import edu.colorado.phet.faraday.model.Compass;
import edu.colorado.phet.faraday.model.Electromagnet;
import edu.colorado.phet.faraday.model.FieldMeter;
import edu.colorado.phet.faraday.model.SourceCoil;
import edu.colorado.phet.faraday.view.BFieldOutsideGraphic;
import edu.colorado.phet.faraday.view.CoilGraphic;
import edu.colorado.phet.faraday.view.ElectromagnetGraphic;
import java.awt.Color;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public class ElectromagnetPanel
extends FaradayPanel {
    private Electromagnet _electromagnetModel;
    private SourceCoil _sourceCoilModel;
    private Battery _batteryModel;
    private ACPowerSupply _acPowerSupplyModel;
    private Compass _compassModel;
    private FieldMeter _fieldMeterModel;
    private CoilGraphic _coilGraphic;
    private BFieldOutsideGraphic _bFieldOutsideGraphic;
    private JRadioButton _batteryRadioButton;
    private JRadioButton _acRadioButton;
    private JCheckBox _bFieldCheckBox;
    private JCheckBox _fieldMeterCheckBox;
    private JCheckBox _compassCheckBox;
    private JSpinner _loopsSpinner;
    private JCheckBox _electronsCheckBox;

    public ElectromagnetPanel(Electromagnet electromagnet, SourceCoil sourceCoil, Battery battery, ACPowerSupply aCPowerSupply, Compass compass, FieldMeter fieldMeter, ElectromagnetGraphic electromagnetGraphic, BFieldOutsideGraphic bFieldOutsideGraphic) {
        assert (electromagnet != null);
        assert (sourceCoil != null);
        assert (battery != null);
        assert (aCPowerSupply != null);
        assert (compass != null);
        assert (fieldMeter != null);
        assert (electromagnetGraphic != null);
        assert (bFieldOutsideGraphic != null);
        this._electromagnetModel = electromagnet;
        this._sourceCoilModel = sourceCoil;
        this._batteryModel = battery;
        this._acPowerSupplyModel = aCPowerSupply;
        this._compassModel = compass;
        this._fieldMeterModel = fieldMeter;
        this._coilGraphic = electromagnetGraphic.getCoilGraphic();
        this._bFieldOutsideGraphic = bFieldOutsideGraphic;
        Border border = BorderFactory.createLineBorder(Color.BLACK, 2);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, FaradayStrings.TITLE_ELECTROMAGNET_PANEL);
        titledBorder.setTitleFont(this.getTitleFont());
        this.setBorder(titledBorder);
        this._bFieldCheckBox = new JCheckBox(FaradayStrings.CHECK_BOX_SHOW_B_FIELD);
        this._fieldMeterCheckBox = new JCheckBox(FaradayStrings.CHECK_BOX_SHOW_FIELD_METER);
        this._compassCheckBox = new JCheckBox(FaradayStrings.CHECK_BOX_SHOW_COMPASS);
        this._electronsCheckBox = new JCheckBox(FaradayStrings.CHECK_BOX_SHOW_ELECTRONS);
        JPanel jPanel = new JPanel();
        JComponent jComponent = new JLabel(FaradayStrings.LABEL_NUMBER_OF_LOOPS);
        Serializable serializable = new SpinnerNumberModel();
        ((SpinnerNumberModel)serializable).setMaximum(new Integer(4));
        ((SpinnerNumberModel)serializable).setMinimum(new Integer(1));
        ((SpinnerNumberModel)serializable).setValue(new Integer(1));
        this._loopsSpinner = new JSpinner((SpinnerModel)((Object)serializable));
        Serializable serializable2 = ((JSpinner.DefaultEditor)this._loopsSpinner.getEditor()).getTextField();
        ((JTextComponent)serializable2).setEditable(false);
        this._loopsSpinner.setPreferredSize(SPINNER_SIZE);
        this._loopsSpinner.setMaximumSize(SPINNER_SIZE);
        this._loopsSpinner.setMinimumSize(SPINNER_SIZE);
        Object object = new EasyGridBagLayout(jPanel);
        jPanel.setLayout((LayoutManager)object);
        ((EasyGridBagLayout)object).addAnchoredComponent(jComponent, 0, 0, 17);
        ((EasyGridBagLayout)object).addAnchoredComponent(this._loopsSpinner, 0, 1, 17);
        jComponent = new JPanel();
        serializable = new TitledBorder(FaradayStrings.TITLE_CURRENT_SOURCE);
        jComponent.setBorder((Border)((Object)serializable));
        serializable2 = new EasyGridBagLayout((JPanel)jComponent);
        jComponent.setLayout((LayoutManager)((Object)serializable2));
        object = new ImageIcon(FaradayResources.getImage("battery_icon.png"));
        ImageIcon imageIcon = new ImageIcon(FaradayResources.getImage("battery_icon_selected.png"));
        this._batteryRadioButton = new JRadioButton(FaradayStrings.RADIO_BUTTON_DC, (Icon)object);
        this._batteryRadioButton.setVerticalTextPosition(3);
        this._batteryRadioButton.setHorizontalTextPosition(0);
        this._batteryRadioButton.setSelectedIcon(imageIcon);
        ImageIcon imageIcon2 = new ImageIcon(FaradayResources.getImage("acPowerSupply_icon.png"));
        ImageIcon imageIcon3 = new ImageIcon(FaradayResources.getImage("acPowerSupply_icon_selected.png"));
        this._acRadioButton = new JRadioButton(FaradayStrings.RADIO_BUTTON_AC, imageIcon2);
        this._acRadioButton.setVerticalTextPosition(3);
        this._acRadioButton.setHorizontalTextPosition(0);
        this._acRadioButton.setSelectedIcon(imageIcon3);
        ((EasyGridBagLayout)serializable2).addAnchoredComponent(this._batteryRadioButton, 0, 0, 17);
        ((EasyGridBagLayout)serializable2).addAnchoredComponent(this._acRadioButton, 0, 1, 17);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._batteryRadioButton);
        buttonGroup.add(this._acRadioButton);
        serializable = new EasyGridBagLayout(this);
        this.setLayout((LayoutManager)((Object)serializable));
        int n = 0;
        ((EasyGridBagLayout)serializable).addFilledComponent(jComponent, n++, 0, 2);
        ((EasyGridBagLayout)serializable).addComponent(jPanel, n++, 0);
        ((EasyGridBagLayout)serializable).addComponent(this._bFieldCheckBox, n++, 0);
        ((EasyGridBagLayout)serializable).addComponent(this._compassCheckBox, n++, 0);
        ((EasyGridBagLayout)serializable).addComponent(this._fieldMeterCheckBox, n++, 0);
        ((EasyGridBagLayout)serializable).addComponent(this._electronsCheckBox, n++, 0);
        object = new EventListener();
        this._batteryRadioButton.addActionListener((ActionListener)object);
        this._acRadioButton.addActionListener((ActionListener)object);
        this._bFieldCheckBox.addActionListener((ActionListener)object);
        this._fieldMeterCheckBox.addActionListener((ActionListener)object);
        this._compassCheckBox.addActionListener((ActionListener)object);
        this._electronsCheckBox.addActionListener((ActionListener)object);
        this._loopsSpinner.addChangeListener((ChangeListener)object);
        this.update();
    }

    public void update() {
        this._batteryRadioButton.setSelected(this._batteryModel.isEnabled());
        this._acRadioButton.setSelected(this._acPowerSupplyModel.isEnabled());
        this._bFieldCheckBox.setSelected(this._bFieldOutsideGraphic.isVisible());
        this._fieldMeterCheckBox.setSelected(this._fieldMeterModel.isEnabled());
        this._compassCheckBox.setSelected(this._compassModel.isEnabled());
        this._electronsCheckBox.setSelected(this._coilGraphic.isElectronAnimationEnabled());
        this._loopsSpinner.setValue(new Integer(this._sourceCoilModel.getNumberOfLoops()));
    }

    private class EventListener
    implements ActionListener,
    ChangeListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ElectromagnetPanel.this._batteryRadioButton) {
                ElectromagnetPanel.this._batteryModel.setEnabled(true);
                ElectromagnetPanel.this._acPowerSupplyModel.setEnabled(false);
                ElectromagnetPanel.this._electromagnetModel.setCurrentSource(ElectromagnetPanel.this._batteryModel);
            } else if (actionEvent.getSource() == ElectromagnetPanel.this._acRadioButton) {
                ElectromagnetPanel.this._batteryModel.setEnabled(false);
                ElectromagnetPanel.this._acPowerSupplyModel.setEnabled(true);
                ElectromagnetPanel.this._electromagnetModel.setCurrentSource(ElectromagnetPanel.this._acPowerSupplyModel);
            } else if (actionEvent.getSource() == ElectromagnetPanel.this._bFieldCheckBox) {
                ElectromagnetPanel.this._bFieldOutsideGraphic.setVisible(ElectromagnetPanel.this._bFieldCheckBox.isSelected());
            } else if (actionEvent.getSource() == ElectromagnetPanel.this._fieldMeterCheckBox) {
                ElectromagnetPanel.this._fieldMeterModel.setEnabled(ElectromagnetPanel.this._fieldMeterCheckBox.isSelected());
            } else if (actionEvent.getSource() == ElectromagnetPanel.this._compassCheckBox) {
                ElectromagnetPanel.this._compassModel.setEnabled(ElectromagnetPanel.this._compassCheckBox.isSelected());
            } else if (actionEvent.getSource() == ElectromagnetPanel.this._electronsCheckBox) {
                ElectromagnetPanel.this._coilGraphic.setElectronAnimationEnabled(ElectromagnetPanel.this._electronsCheckBox.isSelected());
            } else {
                throw new IllegalArgumentException("unexpected event: " + actionEvent);
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() != ElectromagnetPanel.this._loopsSpinner) {
                throw new IllegalArgumentException("unexpected event: " + changeEvent);
            }
            int n = (Integer)ElectromagnetPanel.this._loopsSpinner.getValue();
            ElectromagnetPanel.this._sourceCoilModel.setNumberOfLoops(n);
        }
    }
}

