/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.control.dialog;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.dialogs.ColorChooserFactory;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.faraday.FaradayStrings;
import edu.colorado.phet.faraday.module.ICompassGridModule;
import java.awt.Color;
import javax.swing.JDialog;

public class BackgroundColorHandler
implements ColorChooserFactory.Listener {
    private PhetApplication _app;
    private JDialog _dialog;

    public BackgroundColorHandler(PhetApplication phetApplication) {
        this._app = phetApplication;
        String string = FaradayStrings.TITLE_BACKGROUND_COLOR;
        PhetFrame phetFrame = phetApplication.getPhetFrame();
        Color color = phetApplication.getActiveModule().getSimulationPanel().getBackground();
        this._dialog = ColorChooserFactory.createDialog(string, phetFrame, color, this);
    }

    public JDialog getDialog() {
        return this._dialog;
    }

    public void colorChanged(Color color) {
        this.handleColorChange(color);
    }

    public void ok(Color color) {
        this.handleColorChange(color);
    }

    public void cancelled(Color color) {
        this.handleColorChange(color);
    }

    private void handleColorChange(Color color) {
        int n = this._app.numModules();
        for (int i = 0; i < n; ++i) {
            Module module = this._app.getModule(i);
            module.getSimulationPanel().setBackground(color);
            if (!(module instanceof ICompassGridModule)) continue;
            ((ICompassGridModule)((Object)module)).setGridBackground(color);
        }
        this._app.getPhetFrame().repaint();
    }
}

