/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.simsharing;

import edu.colorado.phet.common.phetcommon.util.IProguardKeepClass;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;

public class SerializableBufferedImage
implements IProguardKeepClass {
    private final byte[] byteArray;

    public SerializableBufferedImage(BufferedImage bufferedImage) {
        this(bufferedImage, "JPG");
    }

    public SerializableBufferedImage(BufferedImage bufferedImage, String string) {
        this.byteArray = SerializableBufferedImage.toByteArray(bufferedImage, string);
    }

    public BufferedImage toBufferedImage() {
        return SerializableBufferedImage.fromByteArray(this.byteArray);
    }

    public static BufferedImage fromByteArray(byte[] byArray) {
        try {
            return ImageIO.read(new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static byte[] toByteArray(final BufferedImage bufferedImage, final String string) {
        try {
            return new ByteArrayOutputStream(){
                {
                    ImageIO.write((RenderedImage)bufferedImage, string, this);
                }
            }.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public String toString() {
        return "SerializableBufferedImage{byteArray=" + Arrays.toString(this.byteArray) + '}';
    }
}

